/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.lpar;

import com.ibm.hsc.auiml.databeans.profile.PIProfileVirtualIODataBean;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.client.PIVirtualEthernetDataBean;
import com.ibm.hsc.client.PIVirtualSCSIDataBean;
import com.ibm.hsc.client.PIVirtualSerialDataBean;
import com.ibm.hsc.client.PIVirtualSlotDataBean;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.websm.common.CecUtils;
import com.ibm.hsc.websm.common.LparUtils;
import com.ibm.hsc.websm.lpar.PIDlparVirtualIOCommitListener;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskManagerException;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;

public class PIDlparVIODialog {
    private MOXContainerObj m_moxObj = null;
    private boolean m_readAccess = true;
    private String m_profileKey = null;
    private PICECDataBean m_cimCecBean = null;
    private PILPARProfileDataBean m_cimProfileBean = null;
    private PILPARDataBean m_lparBean = null;
    private final String DLPAR = "DLPAR";

    public PIDlparVIODialog(MOXContainerObj mOXContainerObj, boolean bl) throws PIHscClientException, HSCException, Exception {
        this.debug("reaching constructor()");
        this.m_moxObj = mOXContainerObj;
        this.m_readAccess = bl;
        Object[] objectArray = new Object[]{mOXContainerObj};
        this.debug("getting CEC databean");
        this.m_cimCecBean = (PICECDataBean)mOXContainerObj.getMOClass().invokeStaticMethod("getCECDataBean", objectArray);
        this.debug("getting Profile databean");
        this.m_cimProfileBean = (PILPARProfileDataBean)mOXContainerObj.getMOClass().invokeStaticMethod("getLPARProfileDataBean", objectArray);
        String[] stringArray = new String[]{"curr_max_virtual_slots"};
        String string = mOXContainerObj.getHost().getName();
        String string2 = mOXContainerObj.getKey();
        String string3 = string2.substring(0, string2.indexOf("*"));
        String string4 = (String)mOXContainerObj.getPropertyValue("nameSpace_Prop");
        String string5 = string2.substring(string2.indexOf("*") + 1, string2.indexOf("~"));
        objectArray = new Object[]{string, string4, string5, string3, stringArray};
        this.debug("getting Lpar databean");
        this.m_lparBean = (PILPARDataBean)mOXContainerObj.getMOClass().invokeStaticMethod("getLparDataBean", objectArray);
    }

    public void showDialog() {
        try {
            this.displayVirtualIO(this.m_moxObj, this.m_cimCecBean, this.m_cimProfileBean);
        }
        catch (HSCException hSCException) {
            hSCException.printStackTrace(System.out);
        }
        catch (PIHscClientException pIHscClientException) {
            pIHscClientException.printStackTrace(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void debug(String string) {
        System.err.println("| DlparVIO." + string);
    }

    private Object[] getVirtualDevices() throws PIHscClientException, HSCException, Exception {
        this.debug("in getVirtualDevices()");
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = new Object[]{this.m_moxObj};
        Vector vector = (Vector)this.m_moxObj.getMOClass().invokeStaticMethod("getVirtualDevices", objectArray2);
        objectArray[0] = ((Vector)vector.elementAt(0)).elements();
        objectArray[1] = ((ArrayList)vector.elementAt(1)).iterator();
        objectArray[2] = ((ArrayList)vector.elementAt(2)).iterator();
        return objectArray;
    }

    public void displayVirtualIO(MOXContainerObj mOXContainerObj, PICECDataBean pICECDataBean, PILPARProfileDataBean pILPARProfileDataBean) throws HSCException, PIHscClientException, Exception {
        Object object;
        Object object2;
        Object object3;
        this.debug("in displayVirtualIO()");
        Hashtable hashtable = null;
        Vector vector = null;
        HashMap<UnsignedInt16, PIVirtualEthernetDataBean> hashMap = new HashMap<UnsignedInt16, PIVirtualEthernetDataBean>();
        HashMap<UnsignedInt16, PIVirtualSCSIDataBean> hashMap2 = new HashMap<UnsignedInt16, PIVirtualSCSIDataBean>();
        HashMap<UnsignedInt16, PIVirtualSerialDataBean> hashMap3 = new HashMap<UnsignedInt16, PIVirtualSerialDataBean>();
        Object[] objectArray = this.getVirtualDevices();
        int n = 0;
        Enumeration enumeration = (Enumeration)objectArray[0];
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object3 = (PIVirtualEthernetDataBean)enumeration.nextElement();
                hashMap.put(((PIVirtualSlotDataBean)object3).getSlotNumber(), (PIVirtualEthernetDataBean)object3);
                ++n;
            }
        }
        this.debug("veth : " + hashMap.toString());
        object3 = (Iterator)objectArray[1];
        while (object3.hasNext()) {
            object2 = (PIVirtualSCSIDataBean)object3.next();
            hashMap2.put(((PIVirtualSlotDataBean)object2).getSlotNumber(), (PIVirtualSCSIDataBean)object2);
        }
        this.debug("veth : " + hashMap2.toString());
        object2 = (Iterator)objectArray[2];
        while (object2.hasNext()) {
            object = (PIVirtualSerialDataBean)object2.next();
            hashMap3.put(((PIVirtualSlotDataBean)object).getSlotNumber(), (PIVirtualSerialDataBean)object);
        }
        this.debug("veth : " + hashMap3.toString());
        pILPARProfileDataBean.setVirtualEthernetAdapters(hashMap);
        pILPARProfileDataBean.setVirtualSCSIAdapters(hashMap2);
        pILPARProfileDataBean.setVirtualSerialAdapters(hashMap3);
        vector = LparUtils.getLparProfNames(mOXContainerObj);
        object = pILPARProfileDataBean.getName();
        if (object != null) {
            vector.remove(object);
        }
        MOXContainerObj mOXContainerObj2 = LparUtils.getCECMOXContainerObj(mOXContainerObj);
        hashtable = CecUtils.getCecLparNames(mOXContainerObj2);
        PIProfileVirtualIODataBean pIProfileVirtualIODataBean = new PIProfileVirtualIODataBean(pICECDataBean, pILPARProfileDataBean, hashtable);
        pIProfileVirtualIODataBean.load();
        pIProfileVirtualIODataBean.setModule("DLPAR");
        pIProfileVirtualIODataBean.setMOXContainer(this.m_moxObj);
        if (this.m_lparBean != null) {
            double d = this.m_lparBean.getCurMaxVirtualIO().intValue();
            this.debug("setting the max virtual adapters : " + d);
            pIProfileVirtualIODataBean.setMaxVirtualSlots(d);
        }
        try {
            this.debug("creating a AUIML adapter");
            AuimlAdapter auimlAdapter = new AuimlAdapter("com.ibm.hsc.auiml.databeans.profile.PIPartitionProfileAuiml", "ProfilePropertySheet", new DataBean[]{pIProfileVirtualIODataBean});
            UserTaskManager userTaskManager = auimlAdapter.getUserTaskManager();
            userTaskManager.removeGroup("ProfileP01General");
            userTaskManager.removeGroup("ProfileP02Memory");
            userTaskManager.removeGroup("ProfileP03Processing");
            userTaskManager.removeGroup("ProfileP04Interactive");
            userTaskManager.removeGroup("ProfileP05PhysicalIO");
            userTaskManager.removeGroup("ProfileP05bTags");
            userTaskManager.removeGroup("ProfileP07Hosting");
            userTaskManager.removeGroup("ProfileP08Other");
            userTaskManager.removeGroup("OptiConnectPanel");
            pIProfileVirtualIODataBean.setUserTaskManager(userTaskManager);
            userTaskManager.addTaskActionListener((TaskActionListener)pIProfileVirtualIODataBean);
            userTaskManager.addCommitListener((TaskActionListener)new PIDlparVirtualIOCommitListener(mOXContainerObj, pILPARProfileDataBean, hashMap, hashMap3, hashMap2, userTaskManager));
            userTaskManager.setEnabled("ProfileP06VirtualIO.MaxVirtualSlots", false);
            userTaskManager.setShown("ProfileP06VirtualIO.RequiredColumn", false);
            userTaskManager.invoke();
        }
        catch (TaskManagerException taskManagerException) {
            taskManagerException.printStackTrace();
        }
    }
}

